from sklearn_extra.cluster import KMedoids
from K_Medoids_Algorithm import cost
import warnings
from sklearn.exceptions import ConvergenceWarning

def k_medoids_generate_uniform(X, k, max_iter=100):
    # Initialize and fit the k-medoids
    warnings.filterwarnings("ignore", category=ConvergenceWarning)

    kmedoids = KMedoids(n_clusters=k, max_iter=max_iter, init='random').fit(X)

    # Cluster labels and medoids
    medoids_centers = kmedoids.cluster_centers_
    medoids_assignment = kmedoids.labels_
    medoids_inertia = cost(X, medoids_centers)

    print(medoids_inertia)
    return medoids_inertia